﻿//------------------------------------------------------------------------------------------------------------------------------------
//  Hi!  There's a really good chance this code originated from http://www.sanderstechnology.com
//
//  Some of this code originated from publically accessible code, such code is so labelled.
//  This code is free to use & distribute, but please be aware that it is a sample product, and is not production quality.
//
//  If it helped you out, we'd really appreciate it if you'd check out the site and *ahem* clicked on some of the ads *wink*.
//  Please (if you can) try to leave this comment header, I can always do with some free advertising.
//  Should you need some help you can try emailing rob.sanders@gmail.com - no guarantees if I can get back to you in a timely fashion.
//  Regards, Rob
//------------------------------------------------------------------------------------------------------------------------------------

#region Using Directives
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using System.Collections.ObjectModel;
using System.Data.Objects;
using Products.WcfServices.DataModel;
#endregion

namespace Products.WcfServices
{
    /// <summary>
    /// Implements the Service Interface
    /// </summary>
    public class ProductService : IProductService
    {
        /// <summary>
        /// A Fairly Vanilla "Get" function
        /// </summary>
        /// <param name="productId">Valid Product ID</param>
        /// <returns>A matching product, or null</returns>
        public Product GetProduct(int productId)
        {
            using (ProductEntities context = new ProductEntities())
            {
                context.ContextOptions.ProxyCreationEnabled = false;
                context.ContextOptions.LazyLoadingEnabled = false;
                
                Product selectedProduct = context.Products.Include("Categories").Where(x => x.ProductId == productId).FirstOrDefault();
                return selectedProduct;
            }
        }

        /// <summary>
        /// A little more complex - get a collection of products in a category
        /// </summary>
        /// <param name="categoryId">The category ID</param>
        /// <returns>A collection of products or null</returns>
        public ReadOnlyCollection<Product> GetProductsByCategory(int categoryId)
        {
            using (ProductEntities context = new ProductEntities())
            {
                context.ContextOptions.ProxyCreationEnabled = false;
                context.ContextOptions.LazyLoadingEnabled = false;

                var result = (from item in context.Categories
                              where item.CategoryId == categoryId
                              select item).FirstOrDefault();

                if (result == null)
                {
                    return null;
                }

                return result.Products.ToList().AsReadOnly();
            }
        }

        /// <summary>
        /// A fairly straightforward "Add or Update" Function
        /// </summary>
        /// <param name="productItem">A Product Entity to Add or Update</param>
        public void UpdateProduct(Product productItem)
        {
            using (ProductEntities context = new ProductEntities())
            {
                Product existingObject = context.Products.Where(x => x.ProductId == productItem.ProductId).FirstOrDefault();

                //no record of this item in the DB, item being passed in has a PK
                if (existingObject == null && productItem.ProductId > 0)
                {
                    //log
                    return;
                }
                //Item has no PK value, must be new
                else if(productItem.ProductId <= 0)
                {
                    context.Products.AddObject(productItem);
                }
                //Item was retrieved, and the item passed has a valid ID, do an update
                else
                {                
                    context.ApplyCurrentValues<Product>("Products", productItem);
                }
                
                context.SaveChanges();
            }
        }
    }
}
