﻿//------------------------------------------------------------------------------------------------------------------------------------
//  Hi!  There's a really good chance this code originated from http://www.sanderstechnology.com
//
//  Some of this code originated from publically accessible code, such code is so labelled.
//  This code is free to use & distribute, but please be aware that it is a sample product, and is not production quality.
//
//  If it helped you out, we'd really appreciate it if you'd check out the site and *ahem* clicked on some of the ads *wink*.
//  Please (if you can) try to leave this comment header, I can always do with some free advertising.
//  Should you need some help you can try emailing rob.sanders@gmail.com - no guarantees if I can get back to you in a timely fashion.
//  Regards, Rob
//------------------------------------------------------------------------------------------------------------------------------------

#region Using Directives
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using System.Collections.ObjectModel;
using Products.WcfServices.DataModel;
#endregion

namespace Products.WcfServices
{
    /// <summary>
    /// Implements the "System Log" Interface
    /// </summary>
    public class SystemLogService : ISystemLogService
    {
        /// <summary>
        /// Something pretty easy
        /// </summary>
        /// <param name="logId"></param>
        /// <returns></returns>
        public SystemLog GetLogEntry(int logId)
        {
            if (logId <= 0)
            {
                throw new ArgumentException("Log Id must be valid");
            }

            using (ProductEntities context = new ProductEntities())
            {
                context.ContextOptions.ProxyCreationEnabled = false;
                context.ContextOptions.LazyLoadingEnabled = false;

                return context.SystemLogs.Where(x => x.SystemlLogId == logId).FirstOrDefault();
            }
        }

        /// <summary>
        /// An option to return a collection
        /// </summary>
        /// <param name="logCategoryId"></param>
        /// <returns></returns>
        public ReadOnlyCollection<SystemLog> GetLogEntryByCategory(int logCategoryId)
        {
            if (logCategoryId <= 0)
            {
                throw new ArgumentException("Log CategoryId must be valid");
            }

            return GetLogEntryByCategoryId(logCategoryId).AsReadOnly();
        }
        
        /// <summary>
        /// An alternative - return a List<> instead of a ReadOnlyCollection<>
        /// </summary>
        /// <param name="logCategoryId"></param>
        /// <returns></returns>
        public List<SystemLog> GetLogEntryByCategoryId(int logCategoryId)
        {
            if (logCategoryId <= 0)
            {
                throw new ArgumentException("Log CategoryId must be valid");
            }

            using (ProductEntities context = new ProductEntities())
            {
                context.ContextOptions.ProxyCreationEnabled = false;
                context.ContextOptions.LazyLoadingEnabled = false;

                var category = context.SystemLogCategories.Include("SystemLogs").Where(x => x.SystemLogCategoryId == logCategoryId).FirstOrDefault();

                if (category == null)
                {
                    return null;
                }
                else
                {
                    return category.SystemLogs.ToList();
                }
            }
        }
    }
}
