﻿//------------------------------------------------------------------------------------------------------------------------------------
//  Hi!  There's a really good chance this code originated from http://www.sanderstechnology.com
//
//  Some of this code originated from publically accessible code, such code is so labelled.
//  This code is free to use & distribute, but please be aware that it is a sample product, and is not production quality.
//
//  If it helped you out, we'd really appreciate it if you'd check out the site and *ahem* clicked on some of the ads *wink*.
//  Please (if you can) try to leave this comment header, I can always do with some free advertising.
//  Should you need some help you can try emailing rob.sanders@gmail.com - no guarantees if I can get back to you in a timely fashion.
//  Regards, Rob
//------------------------------------------------------------------------------------------------------------------------------------

#region Using Directives
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Products.WebServiceClient.ProductReference;
using Products.WebServiceClient.SystemLogReference;
using System.Collections.ObjectModel;
#endregion

namespace Products.WebServiceClient
{
    /// <summary>
    /// A Sample Console/Client
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {            
            try
            {
                using (SystemLogServiceClient logClient = new SystemLogServiceClient())
                {
                    SystemLog log1 = logClient.GetLogEntry(1);
                    Console.WriteLine(log1.Title);

                    SystemLog[] logs = logClient.GetLogEntryByCategoryId(1);

                    foreach (SystemLog log in logs)
                    {
                        Console.WriteLine(log.Title);
                        SystemLog selectedLog = logClient.GetLogEntry(log.SystemlLogId);
                        Console.WriteLine(selectedLog.Title);
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);

                if (ex.InnerException != null)
                {
                    Console.WriteLine(ex.InnerException.Message);
                }
            }            
            
            using (ProductServiceClient client = new ProductReference.ProductServiceClient())
            {
                Product item = client.GetProduct(1);
                Console.WriteLine(item.Title);
                item.Title += "1";
                client.UpdateProduct(item);
            }
        }
    }
}

