﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Reflection;
using BusinessObjects;
using BusinessObjects.Enums;
using System.Workflow.Activities.Rules;
using System.Diagnostics;
using WorkFlowProvider;

namespace Workflow.UnitTests
{
    [TestClass]
    public class BasicTests
    {
        [TestMethod]
        public void CreateNewRule()
        {
            Employee testEmployee = new Employee();

            testEmployee.FirstName = "Joe";
            testEmployee.Surname = "Smith";
            testEmployee.Location = StateEnum.ACT;
            testEmployee.Manager = null;
            testEmployee.DateHired = DateTime.Now.AddYears(-1);
            testEmployee.EmployeeNumber = 99;

            string ruleName = String.Format("{0}UnitTestRule", DateTime.Now.Millisecond);
            string path = Assembly.GetExecutingAssembly().Location.Replace(Assembly.GetExecutingAssembly().ManifestModule.Name, String.Empty);
            
            RuleSet newRule = RulesManager<Employee>.LaunchNewRulesDialog(ruleName, path);
            testEmployee = RulesManager<Employee>.ProcessRule(testEmployee, newRule);

            Trace.WriteLine(testEmployee.FirstName);
            Trace.WriteLine(testEmployee.Surname);
            Trace.WriteLine(testEmployee.DateHired);
        }
    }
}
